# make taxonomy database
clmaketaxdb --includetaxid=7711 taxonomy chordates.taxdb || exit $?
# extract species-level identified sequences
clretrievegi --includetaxa=genus,.+ --maxrank=species --ngword=' sp\.' --taxdb=chordates.taxdb chordates_all_species.txt || exit $?
# make BLAST database
cd blastdb || exit $?
blastdbcmd -db ./nt -target_only -entry_batch ../chordates_all_species.txt -out - | makeblastdb -in - -dbtype nucl -parse_seqids -hash_index -out chordates_all_species -title chordates_all_species || exit $?
tar -cf - chordates_all_species.n* | xz -cz9 > chordates_all_species.tar.xz
sha256sum chordates_all_species.tar.xz > chordates_all_species.tar.xz.sha256
cd .. || exit $?
clmaketaxdb --gilist=chordates_all_species.txt taxonomy chordates_all_species.taxdb || exit $?
tar -cf - chordates_all_species.taxdb | xz -cz9 > chordates_all_species.taxdb.tar.xz
sha256sum chordates_all_species.taxdb.tar.xz > chordates_all_species.taxdb.tar.xz.sha256
