# make taxonomy database
clmaketaxdb --includetaxid=131567 --excludetaxid=7742,6237,7215 taxonomy all_temp.taxdb || exit $?
# extract species-level identified sequences
clretrievegi --includetaxa=genus,.+ --maxrank=species --ngword=' sp\.' --taxdb=all_temp.taxdb all_species.txt || exit $?
clretrievegi --includetaxa=genus,.+ --taxdb=all_temp.taxdb all_genus.txt || exit $?
clretrievegi --includetaxa=family,.+ --taxdb=all_temp.taxdb all_family.txt || exit $?
clretrievegi --includetaxa=order,.+ --taxdb=all_temp.taxdb all_order.txt || exit $?
clretrievegi --includetaxa=class,.+ --taxdb=all_temp.taxdb all_class.txt || exit $?
# del duplicate
clelimdupgi all_species.txt all_genus.txt all_undergenus.txt || exit $?
clelimdupgi all_undergenus.txt all_family.txt all_underfamily.txt || exit $?
clelimdupgi all_underfamily.txt all_order.txt all_underorder.txt || exit $?
clelimdupgi all_underorder.txt all_class.txt all_underclass.txt || exit $?
# make BLAST database
cd blastdb || exit $?
blastdbcmd -db ./nt -target_only -entry_batch ../all_underclass.txt -out - | makeblastdb -in - -dbtype nucl -parse_seqids -hash_index -out all_class -title all_class || exit $?
blastdb_aliastool -dbtype nucl -db all_class -gilist ../all_underorder.txt -out all_order -title all_order || exit $?
blastdb_aliastool -dbtype nucl -db all_class -gilist ../all_underfamily.txt -out all_family -title all_family || exit $?
blastdb_aliastool -dbtype nucl -db all_class -gilist ../all_undergenus.txt -out all_genus -title all_genus || exit $?
blastdb_aliastool -dbtype nucl -db all_class -gilist ../all_species.txt -out all_species -title all_species || exit $?
#blastdb_aliastool -dbtype nucl -db ./nt -gilist ../all_underclass.txt -out all_class -title all_class || exit $?
#blastdb_aliastool -dbtype nucl -db ./nt -gilist ../all_underorder.txt -out all_order -title all_order || exit $?
#blastdb_aliastool -dbtype nucl -db ./nt -gilist ../all_underfamily.txt -out all_family -title all_family || exit $?
#blastdb_aliastool -dbtype nucl -db ./nt -gilist ../all_undergenus.txt -out all_genus -title all_genus || exit $?
#blastdb_aliastool -dbtype nucl -db ./nt -gilist ../all_species.txt -out all_species -title all_species || exit $?
#for f in `ls all_class.??.nsq | egrep -o 'all_class\.[0-9][0-9]'`; do (tar -cf - $f.* | xz -cz9 > $f.tar.xz; sha256sum $f.tar.xz > $f.tar.xz.sha256)& done
#tar -cf - all_*.nal all*.n.gil | xz -cz9 > all_class.tar.xz
#sha256sum all_class.tar.xz > all_class.tar.xz.sha256
cd .. || exit $?
# minimize taxdb
clmaketaxdb --gilist=all_underclass.txt taxonomy all_class.taxdb || exit $?
ln -s all_class.taxdb all_order.taxdb || exit $?
ln -s all_class.taxdb all_family.taxdb || exit $?
ln -s all_class.taxdb all_genus.taxdb || exit $?
ln -s all_class.taxdb all_species.taxdb || exit $?
#tar -cf - all_class.taxdb all_order.taxdb all_family.taxdb all_genus.taxdb all_species.taxdb | xz -cz9 > all_class.taxdb.tar.xz
#sha256sum all_class.taxdb.tar.xz > all_class.taxdb.tar.xz.sha256
