use strict;

my $buildno = '0.1.2014.02.06';

print(STDERR <<"_END");
clrevcompseq $buildno
=======================================================================

Official web site of this script is
http://www.fifthdimension.jp/products/claident/ .
To know script details, see above URL.

Copyright (C) 2011-2014  Akifumi S. Tanabe

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

_END

# display usage if command line options were not specified
unless (@ARGV) {
	&helpMessage();
}

# initialize variables
my $outputfile = $ARGV[-1];
if (-e $outputfile) {
	&errorMessage(__LINE__, "\"$outputfile\" already exists.");
}
my $inputfile = $ARGV[-2];
unless (-e $inputfile) {
	&errorMessage(__LINE__, "\"$inputfile\" does not exist.");
}
my $qualfile;
for (my $i = 0; $i < scalar(@ARGV) - 2; $i ++) {
	if ($ARGV[$i] =~ /^-+(?:qual|qualfile|q)=(.+)$/i) {
		$qualfile = $1;
	}
	else {
		&errorMessage(__LINE__, "\"$ARGV[$i]\" is unknown option.");
	}
}
unless ($qualfile) {
	$qualfile = "$inputfile.qual";
}

# read input file
my $inputhandle;
unless (open($inputhandle, "< $inputfile")) {
	&errorMessage(__LINE__, "Cannot open \"$inputfile\".");
}
my $outputhandle;
unless (open($outputhandle, "> $outputfile")) {
	&errorMessage(__LINE__, "Cannot write \"$outputfile\".");
}
my $qualhandle;
my $outqualhandle;
if (-e $qualfile) {
	unless (open($qualhandle, "< $qualfile")) {
		&errorMessage(__LINE__, "Cannot open \"$qualfile\".");
	}
	unless (open($outqualhandle, "> $outputfile.qual")) {
		&errorMessage(__LINE__, "Cannot write \"$outputfile.qual\".");
	}
}
{
	local $/ = "\n>";
	while (<$inputhandle>) {
		if (/^>?\s*(\S[^\r\n]*)\r?\n(.+)\r?\n/s) {
			my $taxon = $1;
			my $sequence = $2;
			$taxon =~ s/\s+$//;
			$sequence =~ s/[> \r\n]//g;
			$sequence = reversecomplement($sequence);
			print($outputhandle ">$taxon\n");
			print($outputhandle "$sequence\n");
			if (-e $qualfile) {
				local $/ = "\n>";
				my $qualline = readline($qualhandle);
				if ($qualline =~ /^>?\s*(\S[^\r\n]*)\r?\n(.+)\r?\n/s) {
					my $temp = $1;
					my $qual = $2;
					$temp =~ s/\s+$//;
					if ($temp eq $taxon) {
						$qual =~ s/\s*([0-9 ]+)\s*/$1/;
						$qual = reversecomplementQV($qual);
						print($outqualhandle ">$taxon\n");
						print($outqualhandle "$qual\n");
					}
					else {
						&errorMessage(__LINE__, "The quality file is invalid.");
					}
				}
				else {
					&errorMessage(__LINE__, "The quality file is invalid.");
				}
			}
		}
	}
}
close($inputhandle);
close($outputhandle);
if (-e $qualfile) {
	close($qualhandle);
	close($outqualhandle);
}

sub reversecomplement {
	my @seq = split(/ */, $_[0]);
	@seq = reverse(@seq);
	my $seq = join('', @seq);
	$seq =~ tr/ACGTMRYKVHDB/TGCAKYRMBDHV/;
	return($seq);
}

sub reversecomplementQV {
	my @qual = split(/ +/, $_[0]);
	@qual = reverse(@qual);
	return(join(' ', @qual));
}

sub errorMessage {
	my $lineno = shift(@_);
	my $message = shift(@_);
	print(STDERR "ERROR!: line $lineno\n$message\n");
	print(STDERR "If you want to read help message, run this script without options.\n");
	exit(1);
}

sub helpMessage {
	print(STDERR <<"_END");
Usage
=====
clrevcompseq options inputfile outputfile

Command line options
====================
-q, --qualfile=FILENAME
  Specify .qual file name. (default: inputfile.qual)

Acceptable input file formats
=============================
FASTA (+.qual)
_END
	exit;
}
