# search by keywords at INSD
clretrievegi --keywords='"ddbj embl genbank"[Filter] AND (txid2759[Organism:exp] AND 200:10000[Sequence Length] AND ((28S[Title] OR "large subunit"[Title] OR LSU[Title]) AND ("ribosomal RNA"[Title] OR rRNA[Title] OR "ribosomal DNA"[Title] OR rDNA[Title])) NOT spacer[Title] NOT environmental[Title] NOT uncultured[Title] NOT unclassified[Title] NOT unidentified[Title] NOT pseudogene[Title])' eukaryota_28S.txt || exit $?
# make taxonomy database
clmaketaxdb --gilist=eukaryota_28S.txt taxonomy eukaryota_28S_temp.taxdb || exit $?
# extract genus-level identified sequences
clretrievegi --includetaxa=genus,.+ --gilist=eukaryota_28S.txt --taxdb=eukaryota_28S_temp.taxdb eukaryota_28S_genus.txt || exit $?
# extract species-level identified sequences
clretrievegi --includetaxa=genus,.+ --maxrank=species --ngword=' sp\.' --gilist=eukaryota_28S.txt --taxdb=eukaryota_28S_temp.taxdb eukaryota_28S_species.txt || exit $?
# make BLAST database
cd blastdb || exit $?
#blastdb_aliastool -dbtype nucl -db ./nt -gilist ../eukaryota_28S_genus.txt -out eukaryota_28S_genus -title eukaryota_28S_genus || exit $?
#blastdb_aliastool -dbtype nucl -db ./nt -gilist ../eukaryota_28S_species.txt -out eukaryota_28S_species -title eukaryota_28S_species || exit $?
blastdbcmd -db ./nt -target_only -entry_batch ../eukaryota_28S_genus.txt -out - | makeblastdb -in - -dbtype nucl -parse_seqids -hash_index -out eukaryota_28S_genus -title eukaryota_28S_genus || exit $?
blastdb_aliastool -dbtype nucl -db eukaryota_28S_genus -gilist ../eukaryota_28S_species.txt -out eukaryota_28S_species -title eukaryota_28S_species || exit $?
cd .. || exit $?
# minimize taxdb
clmaketaxdb --gilist=eukaryota_28S_genus.txt taxonomy eukaryota_28S_genus.taxdb || exit $?
ln -s eukaryota_28S_genus.taxdb eukaryota_28S_species.taxdb || exit $?
rm eukaryota_28S_temp.taxdb || exit $?
