# make taxonomy database
clmaketaxdb --includetaxid=131567 --excludetaxid=7742,6237,7215 taxonomy all_class.taxdb || exit $?
# extract species-level identified sequences
clretrievegi --includetaxa=genus,.+ --maxrank=species --ngword=' sp\.' --taxdb=all_class.taxdb all_species.txt || exit $?
clretrievegi --includetaxa=genus,.+ --taxdb=all_class.taxdb all_genus.txt || exit $?
clretrievegi --includetaxa=family,.+ --taxdb=all_class.taxdb all_family.txt || exit $?
clretrievegi --includetaxa=order,.+ --taxdb=all_class.taxdb all_order.txt || exit $?
clretrievegi --includetaxa=class,.+ --taxdb=all_class.taxdb all_class.txt || exit $?
# del duplicate
clelimdupgi all_genus.txt all_family.txt all_underfamily.txt || exit $?
clelimdupgi all_underfamily.txt all_order.txt all_underorder.txt || exit $?
clelimdupgi all_underorder.txt all_class.txt all_underclass.txt || exit $?
# make BLAST database
cd blastdb || exit $?
blastdbcmd -db ./nt -target_only -entry_batch ../all_underclass.txt -out - | makeblastdb -in - -dbtype nucl -parse_seqids -hash_index -out all_class -title all_class || exit $?
blastdb_aliastool -dbtype nucl -db all_class -gilist ../all_underorder.txt -out all_order -title all_order || exit $?
blastdb_aliastool -dbtype nucl -db all_class -gilist ../all_underfamily.txt -out all_family -title all_family || exit $?
blastdb_aliastool -dbtype nucl -db all_class -gilist ../all_genus.txt -out all_genus -title all_genus || exit $?
blastdb_aliastool -dbtype nucl -db all_class -gilist ../all_species.txt -out all_species -title all_species || exit $?
#blastdb_aliastool -dbtype nucl -db ./nt -gilist ../all_underclass.txt -out all_class -title all_class || exit $?
#blastdb_aliastool -dbtype nucl -db ./nt -gilist ../all_underorder.txt -out all_order -title all_order || exit $?
#blastdb_aliastool -dbtype nucl -db ./nt -gilist ../all_underfamily.txt -out all_family -title all_family || exit $?
#blastdb_aliastool -dbtype nucl -db ./nt -gilist ../all_genus.txt -out all_genus -title all_genus || exit $?
#blastdb_aliastool -dbtype nucl -db ./nt -gilist ../all_species.txt -out all_species -title all_species || exit $?
cd .. || exit $?
ln -s all_class.taxdb all_order.taxdb || exit $?
ln -s all_class.taxdb all_family.taxdb || exit $?
ln -s all_class.taxdb all_genus.taxdb || exit $?
ln -s all_class.taxdb all_species.taxdb || exit $?
