use strict;

my $buildno = '0.1.2013.03.14';

print(STDERR <<"_END");
clelimdupgi $buildno
=======================================================================

Official web site of this script is
http://www.fifthdimension.jp/products/claident/ .
To know script details, see above URL.

Copyright (C) 2011-2013  Akifumi S. Tanabe

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

_END

# display usage if command line options were not specified
unless (@ARGV) {
	&helpMessage();
}

# get output file name
my $outputfile = $ARGV[-1];
# check output file
if (-e $outputfile) {
	&errorMessage(__LINE__, "Output file already exists.");
}

my %inputfiles;
for (my $i = 0; $i < scalar(@ARGV) - 1; $i ++) {
	my @temp = glob($ARGV[$i]);
	if (scalar(@temp) > 0) {
		foreach (@temp) {
			if (!exists($inputfiles{$_})) {
				$inputfiles{$_} = 1;
			}
			else {
				&errorMessage(__LINE__, "\"$_\" is doubly specified.");
			}
		}
	}
	else {
		&errorMessage(__LINE__, "Input file does not exist.");
	}
}

my %gis;
foreach my $inputfile (keys(%inputfiles)) {
	my $inputhandle;
	unless (open($inputhandle, "< $inputfile")) {
		&errorMessage(__LINE__, "Cannot open \"$inputfile\".");
	}
	while (<$inputhandle>) {
		if (/^\d+/) {
			$gis{$&} = 1;
		}
	}
	close($inputhandle);
}

my $outputhandle;
unless (open($outputhandle, "> $outputfile")) {
	&errorMessage(__LINE__, "Cannot write \"$outputfile\"");
}
foreach (keys(%gis)) {
	print($outputhandle "$_\n");
}
close($outputhandle);

# error message
sub errorMessage {
	my $lineno = shift(@_);
	my $message = shift(@_);
	print(STDERR "ERROR!: line $lineno\n$message\n");
	print(STDERR "If you want to read help message, run this script without options.\n");
	exit(1);
}

sub helpMessage {
	print(STDERR <<"_END");
Usage
=====
clelimdupgi inputfiles outputfile

Acceptable input file formats
=============================
GI list
_END
	exit;
}
